
local assets =
{
	Asset( "ANIM", "anim/kurumi_kekedi.zip" ),
}

local function fn()
	local inst = CreateEntity()
	
	inst.entity:AddTransform()
	inst.Transform:SetScale(.75,.75,.75)
	
	inst.entity:AddLight()
	inst.Light:Enable(true)
    inst.Light:SetIntensity(.9)
    inst.Light:SetColour(1, 1, 1)
    inst.Light:SetFalloff(0.3)
    inst.Light:SetRadius(3)
	
	inst.entity:AddAnimState()
	inst.AnimState:SetBank("kurumi_kekedi")
	inst.AnimState:SetBuild("kurumi_kekedi")
	
	inst.AnimState:PlayAnimation("spin", true)
    
	inst.entity:AddSoundEmitter()
	
	inst.entity:AddNetwork()
	
	inst.entity:SetPristine()
	
	if not TheWorld.ismastersim then
        return inst
    end 
	
	inst.persists = false
	
	inst:DoTaskInTime(2, function()
		inst:Remove()	
	end)

	return inst

end
return Prefab("kurumi_kekedi", fn, assets)
